---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：16-プーリング演算（Pooling Operations）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **Pooling2D/3Dクラスの実装詳細**：pooling.pyの先頭150行のみ読み込み
  2. **GlobalPoolingの実装詳細**：ソースコード未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/keras/layers/pooling.py` 1-150行目
- E-02: `tensorflow/core/ops/nn_ops.cc` 39-103行目 AvgPool/FractionalPool
- E-03: `tensorflow/python/keras/layers/pooling.py` 29-103行目 Pooling1D
- E-04: `tensorflow/python/keras/layers/pooling.py` 106-150行目 MaxPooling1D
- E-05: 機能一覧.csv No.16の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pooling1Dは内部でexpand_dims -> pool -> squeezeする | E-03 (67-76行目) | ○ |
| C-02 | strides=Noneの場合pool_sizeが使用される | E-03 (58-59行目) | ○ |
| C-03 | pool_size/stridesはconv_utils.normalize_tupleで正規化 | E-03 (61-62行目) | ○ |
| C-04 | compute_output_shapeはconv_output_lengthで計算 | E-03 (78-93行目) | ○ |
| C-05 | MaxPooling1Dはnn.max_pool2dをpool_functionとして使用 | E-04 | ○ |
| C-06 | AvgPool OpはREGISTER_OPで定義されている | E-02 (84-92行目) | ○ |
| C-07 | FractionalPoolShapeFnはpooling_ratioの各次元で床除算 | E-02 (39-78行目) | ○ |
| C-08 | pooling_ratioは4要素必須 | E-02 (45-48行目) | ○ |
| C-09 | pooling_ratio < 1でInvalidArgument | E-02 (67-72行目) | ○ |
| C-10 | data_formatはchannels_last/channels_first | E-03 (43-48行目 docstring) | ○ |
| C-11 | InputSpecでndim=3を要求（1D） | E-03 (65行目) | ○ |
| C-12 | 出力形状計算でdata_formatに応じて次元を入れ替え | E-03 (78-93行目) | ○ |
| C-13 | Pooling2D/3Dの完全な実装 | **根拠なし** | △ |
| C-14 | GlobalPoolingの実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: Pooling2D/3Dクラスはpooling.pyの150行目以降にあり、未読み込み
  - 候補：`tensorflow/python/keras/layers/pooling.py` 全体の読み込み
- C-14: GlobalPoolingクラスも同ファイルの後半部分にある

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Pooling2D/3D/GlobalPoolingの詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Pooling2D/3Dクラスの実装がPooling1Dと同様のパターンか確認
- [ ] GlobalPoolingクラスの実装詳細を確認
- [ ] C++カーネルのMaxPool Op定義を確認
